﻿/*
PROPERTIES:
	editable			read-write
	editMode			read-write

EVENTS:
	change
	onEditMode
	onEditable
*/



// This adds edit capabilities
_this = this;
edit = {};
var map = _this.map;

// store component settings
edit.initEditMode = _this.editMode;
edit.initEditable = _this.editable;

// OBJECTS
edit.start = {x:0, y:0};
edit.end = {x:0, y:0};

// PROPERTIES
// // editMode
edit._editMode = "pencil";
_this.getEditMode = function(){
	return edit._editMode;
}// get()
_this.setEditMode = function( newValue, doEvent ){
	if(newValue != edit._editMode)
	{// if:  selection is specified
		edit._editMode = newValue;
		// cancel current drawing operation
		edit.cancelDraw();
		// event: selection
		if(doEvent != false){
			_this.dispatchEvent({type:"onEditMode"} );
			_this.onEditMode();
		}
	}// if:  selection changes
}// set()
_this.addProperty( "editMode", _this.getEditMode, _this.setEditMode );



// // editable
edit._editable = false;
_this.getEditable = function(){
	return edit._editable;
}// get()
_this.setEditable = function( newValue, doEvent ){
	if(newValue != edit._editable)
	{// if:  editable changes
		edit._editable = newValue;
		// event
		if(doEvent != false){
			_this.dispatchEvent({type:"onEditable"} );
			_this.onEditable();
		}
	}// if:  editable changes
}// set()
_this.addProperty( "editable", _this.getEditable, _this.setEditable );





// ______________________________________________________________________________
// PROGRAM

// readPosition
edit.readPosition = function()
{
	// get tile positions
	var xTile = Math.floor(_this._xmouse/16);
	var yTile = Math.floor(_this._ymouse/16);
	// enforce min
	xTile = (xTile<0) ? 0 : xTile;
	yTile = (yTile<0) ? 0 : yTile;
	// enforce max
	var xMax = _this._mapData.width-1;
	var yMax = _this._mapData.height-1;
	xTile = (xTile>xMax) ? xMax : xTile;
	yTile = (yTile>yMax) ? yMax : yTile;
	// report the results
	return {x:xTile, y:yTile};
}// readPosition()



edit.canEdit = function()
{
	var output = true;
	if( _this.selectable )
	{// if:  selections are possible
		if( Key.isDown(Key.SHIFT) )
		{// if:  selection key is held
			output = false;
		}// if:  selection key is held
	}// if:  selections are possible
	
	if( _this.selection == undefined )
	{// if:  there are NO tiles to draw
		output = false;
	}// if:  there are NO tiles to draw
	
	return output;
}// canEdit()



edit.cancelDraw = function()
{
	// cancel dragging
	edit.isPressed = false;
	// remove preview
	_this.preview_mc.removeMovieClip();
}// cancelDraw()



edit.updatePreview = function()
{
	// temporarily store drawing coords
	var x1 = edit.start.x;
	var y1 = edit.start.y;
	var x2 = edit.end.x;
	var y2 = edit.end.y;
	// swap coords if neccessary
	if(x1 > x2){
		var xx1 = x1;
		x1 = x2;
		x2 = xx1;
	}// swap x
	if(y1 > y2){
		var yy1 = y1;
		y1 = y2;
		y2 = yy1;
	}// swap y
	x2++;
	y2++;
	
	// reveal the preview image
	edit.previewMask._x = x1*16;
	edit.previewMask._y = y1*16;
	edit.previewMask._width = (x2-x1)*16;
	edit.previewMask._height = (y2-y1)*16;
	
	// draw the preview frame
	edit.preview_mc.selectionImage.x = x1*16;
	edit.preview_mc.selectionImage.y = y1*16;
	var xDiff = x2-x1;
	var yDiff = y2-y1;
	edit.preview_mc.selectionImage.width = xDiff*16;
	edit.preview_mc.selectionImage.height = yDiff*16;
}// updatePreview()



// convert chipset ID -> tile location on chipset bitmap
edit.getCoords = function( id )
{
	var yy = Math.floor(id / 30);
	var xx = id % 30;
	return {x:xx, y:yy};
}// getCoords()




// ---------------------------------------
// PROGRAM MOUSE

edit.isPressed = false;



// press
_this.addEventListener( "onPress", edit );
edit.onPress = function()
{
	if(_this.editable  &&  edit.canEdit() )
	{// if:  "editable" is ON
		if(edit._editMode == "pencil")
		{// if: pencil
			// start drag
			edit.isPressed = true;
			// remember start
			edit.start = edit.readPosition();
			edit.end = edit.readPosition();
			// get ID
			var id = _this.selection[0][0];
			// // image
			map.setTile(edit.end.x, edit.end.y, id, _this.layer);
			// // data
			_this.mapData.layers[_this.layer][edit.end.x][edit.end.y] = id;
			// announce
			_this.dispatchEvent({type:"change"} );
			_this.change();
		}// if: pencil
		
		
		
		else if(edit._editMode == "rectangle")
		{// if: rectangle
			// start drag
			edit.isPressed = true;
			// remember start
			edit.start = edit.readPosition();
			edit.end = edit.readPosition();
			// create preview bitmap
			var previewWidth = _this.selection.length *16;
			var previewHeight = _this.selection[0].length *16;
			edit.preview_pic.dispose();
			delete edit.preview_pic;
			edit.preview_pic = new flash.display.BitmapData( previewWidth, previewHeight, true, 0xffff0000 );
			for(var xx=0; xx<_this.selection.length; xx++)
			{// for:  selection width
				var xPix = xx*16;
				for(var yy=0; yy<_this.selection[0].length; yy++)
				{// for:  selection height
					var yPix = yy*16;
					var id = _this.selection[xx][yy];
					// get source
					var copy_point = edit.getCoords( id );
					var copy_rect = new flash.geom.Rectangle( copy_point.x*16, copy_point.y*16, 16,16 );
					edit.preview_pic.copyPixels( map.chipset_pic, copy_rect, {x:xPix,y:yPix} );
				}// for:  selection height
			}// for:  selection width
			// create preview object
			edit.previewImage.dispose();
			delete edit.previewImage;
			edit.preview_mc = _this.createEmptyMovieClip( "preview_mc", 3 );
			edit.previewImage = edit.preview_mc.createEmptyMovieClip( "previewImage", 0 );
			edit.previewMask = edit.preview_mc.attachMovie( "rectMask", "previewMask", 1 );
			edit.previewImage.setMask( edit.previewMask );
			var previewImage = edit.previewImage;
			// offset preview image
			var offset_mat = new flash.geom.Matrix();
			var xOffset = edit.start.x*16;
			var yOffset = edit.start.y*16;
			offset_mat.translate( xOffset, yOffset );
			// create preview image
			var mapWidth = map.width*16;
			var mapHeight = map.height*16;
			previewImage.clear();
			previewImage.beginBitmapFill( edit.preview_pic, offset_mat, true, false );
			previewImage.moveTo( 0, 0 );									// top-left
			previewImage.lineTo( mapWidth, 0 );						// right
			previewImage.lineTo( mapWidth, mapHeight );		// down
			previewImage.lineTo( 0, mapHeight );					// left
			previewImage.lineTo( 0, 0 );									// up	
			previewImage.endFill();
			// create preview frame
			if(edit.preview_mc.selectionImage == undefined)
			{
				edit.preview_mc.selectionImage = edit.preview_mc.attachMovie( "selection", "selectionImage", 2, {speed:2} );
				
				edit.preview_mc.selectionImage.blendMode = "normal";
				import flash.geom.Transform;
				var colorFx = new Transform( edit.preview_mc.selectionImage );
				import flash.geom.ColorTransform;
				var pasteColor:ColorTransform = new ColorTransform( 1,0.7,0,1, 0,0,0,0);		// blue
				colorFx.colorTransform = pasteColor;
				
			}
			// display preview rectangle
			edit.updatePreview();
		}// if: rectangle
	}// if:  "editable" is ON
}// onPress()



// drag
_this.addEventListener( "onMouseMove", edit );
edit.onMouseMove = function()
{
	if(edit.isPressed )
	{
		if( edit.canEdit() )
		{// if:  editing enabled
			if(edit._editMode == "pencil")
			{// if: pencil
				// start drag
				edit.isPressed = true;
				// remember end
				edit.end = edit.readPosition();
				// get ID
				var selectionWidth = _this.selection.length;
				var selectionHeight = _this.selection[0].length;
				var xSelection = (-edit.start.x+edit.end.x) % selectionWidth;
				var ySelection = (-edit.start.y+edit.end.y) % selectionHeight;
				xSelection = (xSelection<0) ? xSelection+selectionWidth : xSelection;
				ySelection = (ySelection<0) ? ySelection+selectionHeight : ySelection;
				var id = _this.selection[xSelection][ySelection];
				// // image
				map.setTile(edit.end.x, edit.end.y, id, _this.layer);
				// // data
				_this.mapData.layers[_this.layer][edit.end.x][edit.end.y] = id;
				// announce
				_this.dispatchEvent({type:"change"} );
				_this.change();
			}// if: pencil
			
			
			
			else if(edit._editMode == "rectangle")
			{// if: rectangle
				// remember end
				edit.end = edit.readPosition();
				// update preview rectangle
				edit.updatePreview();
			}// if: rectangle
		}// if:  editing enabled
		else
		{// if:  editing disabled
			edit.cancelEditing();
		}// if:  editing disabled
	}// if:  isPressed
}// onMouseMove()



// release
_this.addEventListener( "onRelease", edit );
edit.onRelease = function()
{
	if(edit.isPressed )
	{
		if(edit.canEdit() )
		{// if:  editing enabled
			if(edit._editMode == "pencil")
			{// if: pencil
				// do nothing
			}// if: pencil
			
			
			
			else if(edit._editMode == "rectangle")
			{// if: rectangle
				// remember end
				edit.end = edit.readPosition();
				// temporarily store drawing coords
				var x1 = edit.start.x;
				var y1 = edit.start.y;
				var x2 = edit.end.x;
				var y2 = edit.end.y;
				// swap coords if neccessary
				if(x1 > x2){
					var xx1 = x1;
					x1 = x2;
					x2 = xx1;
				}// swap x
				if(y1 > y2){
					var yy1 = y1;
					y1 = y2;
					y2 = yy1;
				}// swap y
				// replace tiles
				var pasteWidth = edit.end.x - edit.start.x +1;
				var pasteHeight = edit.end.y - edit.start.y +1;
				var selectionWidth = _this.selection.length;
				var selectionHeight = _this.selection[0].length;
				var xOffset = x1;
				var yOffset = y1;
				for(var xx=x1; xx<=x2; xx++)
				{// for:  rectangle width
					for(var yy=y1; yy<=y2; yy++)
					{// for:  rectangle width
						var xSelection = (-edit.start.x+xx) % selectionWidth;
						var ySelection = (-edit.start.y+yy) % selectionHeight;
						xSelection = (xSelection<0) ? xSelection+selectionWidth : xSelection;
						ySelection = (ySelection<0) ? ySelection+selectionHeight : ySelection;
						var id = _this.selection[xSelection][ySelection];
						// // image
						map.setTile(xx, yy, id, _this.layer);
						// // data
						_this.mapData.layers[_this.layer][xx][yy] = id;
					}// for:  rectangle width
				}// for:  rectangle width
				// remove preview
				delete edit.preview_pic;
				edit.preview_mc.removeMovieClip();
				// event: change
				_this.dispatchEvent({type:"change"} );
				_this.change();
			}// if: rectangle
			// release
			edit.isPressed = false;
		}// if:  editing enabled
		else
		{// if:  editing disabled
			edit.cancelEditing();
		}// if:  editing disabled
	}// if:  isPressed
}// onRelease()



// release
_this.addEventListener( "onReleaseOutside", edit );
edit.onReleaseOutside = edit.onRelease;





// ______________________________________________________________________________
// INITIALIZE
_this.editMode = edit.initEditMode;
_this.editable = edit.initEditable;


// ______________________________________________________________________________
// UNLOAD
edit.unload = function()
{
	_this.removeEventListener( "onPress", edit );
	_this.removeEventListener( "onMouseMove", edit );
	_this.removeEventListener( "onRelease", edit );
	_this.removeEventListener( "onReleaseOutside", edit );
	//
	_this.removeEventListener( "unload", edit );
}// unload()
_this.addEventListener( "unload", edit );